require 'rubygems'
require 'rspec'
require 'watir-webdriver'
require 'page-object'
require 'oci8'

require_relative '../../module/DriverUtility'
require_relative '../rspec_helper'
require_relative '../../pages/landing'
require_relative '../../pages/login'
require_relative '../../pages/eula'
require_relative '../../common/common'
require_relative '../../pages/landing_appointments'
require_relative '../../common/cancel_appointment'
require_relative '../../pages/appointments/new_appointment_request'
require_relative '../../pages/appointments/booked_appointment_detail'
require_relative '../../helper/modal'
require_relative '../../module/database/OracleUtility'
require_relative '../../module/DateUtility'
require_relative '../../helper/error_validation'
require_relative '../../module/database/MongoUtility'
require_relative '../../pages/feedback'

describe '[STORY# VAR-9703: Display number of available slots after clinic has been selected]' do

  include DriverUtility
  include OracleUtility
  include DateUtility
  include MongoUtility


  before(:all) do
    initializeConfigurations(VAR_BASE_URL)
    @landing_appointments = LandingAppointments.new(@driver)
    @login = Login.new(@driver)
    @eula = Eula.new(@driver)
    @common = Common.new(@driver)
    @modal = Modal.new(@driver)
    @new_appointment = NewAppointmentRequest.new(@driver)
    @detail = BookedAppointmentDetail.new(@driver)
    @error = Error_Validation.new(@driver)
    @feedback = Feedback.new(@driver)
    TITLE = "Appointments/Requests"

    @tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")
    @nintyDaysLater = getDateNthDaysFromNow(90, "%m/%d/%Y")
    @sevenDaysFromNow = getDateNthDaysFromNow(7, "%m/%d/%Y")

    #mongo
    @db = connectToMongoDB("var-utility")
    restoreCollection("siteSupportingVAR", "var-utility", "siteSupportingMissingLocation.json", @db)
    restoreCollection("clinical-services", "var-utility", "clinical_services_default.json", @db)
    restoreCollection("directBookingEligibilityCriteria", "var-utility", "primaryCareDirectSchedulingNewSettings.json", @db)
    restoreCollection("requestEligibilityCriteria", "var-utility", "requestEligibilityCriteria.json", @db)
    restoreCollection("custom-friendly-text", "var-utility", "facility_friendly_name.json", @db)
    deletePatientData("1113138327")
    @@timeslot = "11:00"
    @clinic_friendly_name ="JP PRIMARY CARE DR. CREAMER"
    @location = "BOSTON HCS VAMC"
    ## The clinic name is diff in cdw v/s mdws but in real world its same per Chris. We may need to update this test once clinic name
    # for details, list and appointment form is being pulled from same place
    @clinic = "BOPACTB1"
    @cancel_appointment = CancelAppointment.new("CLINIC_BASED_BOSTON", "523","#{pw_redacted['userid']}")
    @cancel_appointment.update_appointment_obj("appointmentTime", "#{@sevenDaysFromNow} 11:00:00")
    @cancel_appointment.cancel_appointment()
    deletePatientData("1113138327")
    @common.loginEndsOnHome(pw_redacted)

  end

  after(:all) do
    @driver.close
  end

  context '[AC#VAR-9716|TC#VAR-9717: Display number of available slots after clinic has been selected]' do
    it 'Navigate to Create new appointment details section' do
      @common.selectAddAppointmentButton("VA")
      @new_appointment.selectNewAppointmentAndSchedule(PRIMARY_CARE, "523", "523", "direct")
      @new_appointment.clinic_radio_elements[1].when_present(TIME_OUT_LIMIT)
      expect(@new_appointment.appointment_details_legend).to eq("Appointment Details")

    end

    it "should schedule an appointment successfully once clinic switched" do
      @new_appointment.selectNewAppointmentAndSchedule(PRIMARY_CARE, "523", "523", "direct")
      @new_appointment.selectClinic("444")
      @new_appointment.provideReasonForAppointment("This is new Primary Care Request")
      @new_appointment.enterEmail("testPC@test.com")
      @new_appointment.selectClinic("32")
      @new_appointment.reason_element.when_present(TIME_OUT_LIMIT)
      @new_appointment.provideReasonForAppointment("This is new switched clinic")
      @new_appointment.selectPreferedDate(@sevenDaysFromNow, @@timeslot)
      @@setDate = NewAppointmentRequest.bookedDate
      @new_appointment.enterEmail("testSC@test.com")
      @new_appointment.clickScheduleAppointment
      @common.waitWhileSpinnerPresent()
      Watir::Wait.until {@detail.appointment_details_group_element.present?}
      Watir::Wait.until {@detail.appointment_details_group_element.text.include?("Reason for Appointment")}
      expect(@detail.appointment_status_group_element.text).to eq("Status:  Scheduled")
    end

    it "Should verify appointment details for date/time, clinic and Reason for Appointment" do
      @selectedDay = getDayofWeek(@@setDate)
      @@timeslot = @@timeslot.gsub!(':', '')
      expected_text = [\
          "Date and Time:" + " #{@selectedDay}," + " #{@@setDate}",
          "Date:" + " #{@selectedDay},"+ " #{@@setDate}",
          @@timeslot,
          "Time: #{@@timeslot.gsub("", " ")}",
          "Add to Calendar",
          "Details: " + "#{@location}",
          "#{@clinic_friendly_name}",
          "Also called: #{@clinic}",
          "Please arrive 30 minutes before your scheduled time unless otherwise directed. VA Facility Locator",
          "Cancel Appointment",
          "Reason for Appointment: This is new switched clinic"
      ]
      actual_text = @detail.appointment_details_group_element.text.split("\n")
      actual_text = actual_text.reject { |c| c.empty? }
      expected_text.each_with_index do | expectedScreenRow, i |
        expect(actual_text[i].gsub(/\s+/, '')).to eq(expectedScreenRow.gsub(/\s+/, ''))
      end
    end

    it "Should schedule anther appointment with multiple switches across clinics" do
      @@newTimeSlot = "11:00"
      button_element = @driver.button(:id => 'back-btn')
      @driver.execute_script("$(arguments[0]).click();",button_element)
      @common.waitWhileSpinnerPresent
      @landing_appointments.appointment_header_element.wait_until_present(TIME_OUT_LIMIT)
      @cancel_appointment.cancel_appointment()
      @common.selectAddAppointmentButton("VA")
      @new_appointment.selectNewAppointmentAndSchedule(PRIMARY_CARE, "523", "523", "direct")
      @new_appointment.selectClinic("32")
      @new_appointment.provideReasonForAppointment("This is new Primary Care Request")
      @new_appointment.enterEmail("testPC@test.com")
      @new_appointment.selectClinic("444")
      @new_appointment.reason_element.when_present(TIME_OUT_LIMIT)
      @new_appointment.selectClinic("32")
      @new_appointment.reason_element.when_present(TIME_OUT_LIMIT)
      @new_appointment.provideReasonForAppointment("This is new switched clinic")
      @new_appointment.selectPreferedDate(@sevenDaysFromNow, @@newTimeSlot)
      @@setNewDate = NewAppointmentRequest.bookedDate
      @new_appointment.enterEmail("testSC@test.com")
      @new_appointment.clickScheduleAppointment
      @common.waitWhileSpinnerPresent()
      Watir::Wait.until {@detail.appointment_details_group_element.present?}
      Watir::Wait.until {@detail.appointment_details_group_element.text.include?("Reason for Appointment")}
      expect(@detail.appointment_status_group_element.text).to eq("Status:  Scheduled")
    end

    it "Should verify appointment details for date/time, multi clinic switch and Reason for Appointment" do
      @@newSelectedDay = getDayofWeek(@@setNewDate)
      @@newTimeSlot = @@newTimeSlot.gsub!(':', '')
      expected_text = [\
          "Date and Time:" + " #{@@newSelectedDay}," + " #{@@setNewDate}",
          "Date:" + " #{@@newSelectedDay},"+ " #{@@setNewDate}",
          @@newTimeSlot,
          "Time: #{@@newTimeSlot.gsub("", " ")}",
          "Add to Calendar",
          "Details: " + "#{@location}",
          "#{@clinic_friendly_name}",
          "Also called: #{@clinic}",
          "Please arrive 30 minutes before your scheduled time unless otherwise directed. VA Facility Locator",
          "Cancel Appointment",
          "Reason for Appointment: This is new switched clinic"
      ]
      actual_text = @detail.appointment_details_group_element.text.split("\n")
      actual_text = actual_text.reject { |c| c.empty? }
      expected_text.each_with_index do | expectedScreenRow, i |
        expect(actual_text[i].gsub(/\s+/, '')).to eq(expectedScreenRow.gsub(/\s+/, ''))
      end
    end
  end
end
